/*
 * Definitions for communicating with FMS.
 */

/*
 * forward references
 */
struct lf_alert;

/*
 * Current status
 */
struct lf_fms_status {
  int hosts_known;
  int fmas_found;
  int unacked_alerts;
  int mapping_complete;
  lf_string_t last_mapper;
  int db_complete;
};

/*
 * prototypes
 */
int lf_fms_connect(char *fms_names);
void lf_fms_disconnect(int fms);
int lf_send_fms_msg(int fms, int type, void *msgbuf, int len);
int lf_send_fms_header(int fms, int type, int len);
int lf_fms_query_alerts(int fms, int show_acked,
                        int show_relics, struct lf_alert **alerts);
int lf_ack_alert(int fms, uint32_t id);
int lf_fms_query_status(int fms, struct lf_fms_status *sp);
int lf_fms_switch_maintenance(int fms, char *enc_name, int slot,
    int port_label, int up);
